<?php
/**
 * Teste Específico - Registro do Berapay
 */

// Verificar se estamos no WordPress
if (!defined('ABSPATH')) {
    echo "<h2>❌ Plugin não está sendo executado no WordPress</h2>";
    echo "<p>Este arquivo deve ser acessado através do WordPress.</p>";
    exit;
}

echo "<h1>🔍 Teste Específico - Registro do Berapay</h1>";
echo "<hr>";

// Verificar se WooCommerce está ativo
if (!class_exists('WooCommerce')) {
    echo "<p>❌ WooCommerce não está ativo!</p>";
    exit;
}

echo "<p>✅ WooCommerce está ativo</p>";

// Verificar se a classe do gateway existe
if (!class_exists('WC_PIX_Gateway')) {
    echo "<p>❌ Classe WC_PIX_Gateway não encontrada!</p>";
    echo "<p>Verifique se o arquivo includes/class-wc-pix-gateway.php está sendo carregado.</p>";
    exit;
}

echo "<p>✅ Classe WC_PIX_Gateway encontrada</p>";

// Verificar se o gateway está registrado
$gateways = apply_filters('woocommerce_payment_gateways', array());

echo "<h3>Gateways Registrados:</h3>";
echo "<ul>";
foreach ($gateways as $gateway) {
    echo "<li>{$gateway}</li>";
}
echo "</ul>";

// Verificar especificamente pelo PIX
$pix_found = false;
foreach ($gateways as $gateway) {
    if ($gateway === 'WC_PIX_Gateway') {
        $pix_found = true;
        break;
    }
}

if ($pix_found) {
    echo "<p>✅ Berapay está registrado</p>";
} else {
    echo "<p>❌ Berapay NÃO está registrado</p>";
}

// Verificar se o gateway está sendo instanciado
echo "<h3>Teste de Instanciação:</h3>";
try {
    $pix_gateway = new WC_PIX_Gateway();
    echo "<p>✅ Berapay foi instanciado com sucesso</p>";
    echo "<p><strong>ID:</strong> " . $pix_gateway->id . "</p>";
    echo "<p><strong>Título:</strong> " . $pix_gateway->method_title . "</p>";
    echo "<p><strong>Descrição:</strong> " . $pix_gateway->method_description . "</p>";
} catch (Exception $e) {
    echo "<p>❌ Erro ao instanciar gateway: " . $e->getMessage() . "</p>";
}

// Verificar configurações do WooCommerce
echo "<h3>Configurações do WooCommerce:</h3>";
$wc_settings = get_option('woocommerce_pix_gateway_settings', array());

if (!empty($wc_settings)) {
    echo "<p>✅ Configurações do gateway encontradas</p>";
    echo "<pre>" . print_r($wc_settings, true) . "</pre>";
} else {
    echo "<p>❌ Configurações do gateway NÃO encontradas</p>";
}

// Verificar se o gateway está habilitado
if (isset($wc_settings['enabled']) && $wc_settings['enabled'] === 'yes') {
    echo "<p>✅ Gateway está habilitado</p>";
} else {
    echo "<p>❌ Gateway NÃO está habilitado</p>";
}

// Verificar hooks
echo "<h3>Hooks Verificados:</h3>";

if (has_filter('woocommerce_payment_gateways')) {
    echo "<p>✅ Filtro woocommerce_payment_gateways ativo</p>";
} else {
    echo "<p>❌ Filtro woocommerce_payment_gateways NÃO ativo</p>";
}

// Verificar se o plugin está sendo carregado
echo "<h3>Status do Plugin:</h3>";
$active_plugins = get_option('active_plugins');
$plugin_found = false;

foreach ($active_plugins as $plugin) {
    if (strpos($plugin, 'woocommerce-pix-gateway') !== false) {
        $plugin_found = true;
        echo "<p>✅ Plugin ativo: {$plugin}</p>";
        break;
    }
}

if (!$plugin_found) {
    echo "<p>❌ Plugin NÃO está ativo!</p>";
}

// Verificar se há métodos de pagamento disponíveis
echo "<h3>Métodos de Pagamento Disponíveis:</h3>";
if (function_exists('WC')) {
    $available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
    
    if (!empty($available_gateways)) {
        echo "<p>✅ Métodos de pagamento disponíveis:</p>";
        echo "<ul>";
        foreach ($available_gateways as $gateway_id => $gateway) {
            echo "<li>{$gateway->get_title()} ({$gateway_id})</li>";
        }
        echo "</ul>";
    } else {
        echo "<p>❌ Nenhum método de pagamento disponível</p>";
    }
    
    // Verificar se o PIX está entre os disponíveis
    $pix_available = false;
    foreach ($available_gateways as $gateway_id => $gateway) {
        if ($gateway_id === 'pix_gateway') {
            $pix_available = true;
            break;
        }
    }
    
    if ($pix_available) {
        echo "<p>✅ Berapay está disponível no checkout</p>";
    } else {
        echo "<p>❌ Berapay NÃO está disponível no checkout</p>";
    }
} else {
    echo "<p>❌ WooCommerce não está funcionando corretamente</p>";
}

// Verificar se há produtos no carrinho
echo "<h3>Teste do Carrinho:</h3>";
if (function_exists('WC')) {
    $cart = WC()->cart;
    if ($cart && !$cart->is_empty()) {
        echo "<p>✅ Carrinho tem itens</p>";
        echo "<p>Total: R$ " . number_format($cart->get_total(), 2, ',', '.') . "</p>";
    } else {
        echo "<p>⚠️ Carrinho está vazio</p>";
        echo "<p>Adicione um produto ao carrinho para testar o checkout</p>";
    }
} else {
    echo "<p>❌ WooCommerce não está funcionando corretamente</p>";
}

echo "<hr>";
echo "<h3>💡 Soluções:</h3>";

if (!$plugin_found) {
    echo "<p>1. Ative o plugin em Plugins > Plugins Instalados</p>";
}

if (!$pix_found) {
    echo "<p>2. Reative o plugin para registrar o gateway</p>";
}

if (empty($wc_settings)) {
    echo "<p>3. Configure o gateway em WooCommerce > Configurações > Pagamentos</p>";
}

if (isset($wc_settings['enabled']) && $wc_settings['enabled'] !== 'yes') {
    echo "<p>4. Habilite o gateway nas configurações</p>";
}

if (!$pix_available) {
    echo "<p>5. Verifique se o gateway está habilitado e configurado corretamente</p>";
}

echo "<hr>";
echo "<h3>🔗 Links Úteis:</h3>";
echo "<p><a href='" . admin_url('admin.php?page=wc-pix-gateway-settings') . "'>⚙️ Configurações do Plugin</a></p>";
echo "<p><a href='" . admin_url('admin.php?page=wc-settings&tab=checkout') . "'>💳 Configurações de Pagamento</a></p>";
echo "<p><a href='" . admin_url('plugins.php') . "'>📦 Gerenciar Plugins</a></p>";
echo "<p><a href='" . home_url('/checkout/') . "'>🛒 Ir para o Checkout</a></p>";

echo "<hr>";
echo "<p><em>Teste concluído em: " . date('d/m/Y H:i:s') . "</em></p>";
?>
